// windmove.c
#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#include "windmove.h"

//
// spostamento relativo, senza deformazioni, di una
// finestra; facoltativamente la mantiene entro un certo
// rettangolo (se pRectLimite==0, cio` non si applica)
//
BOOL WindMove(HWND hwnd, int dx, int dy, LPRECT pRectLimite)
{
    // scopre la posizione attuale
    WINDOWPLACEMENT wp;
    ZeroMemory(&wp, sizeof(wp));
    wp.length = sizeof(wp);
    if(!GetWindowPlacement(hwnd, &wp))
        return FALSE;

    // applica lo spostamento relativo
    wp.rcNormalPosition.left   += dx;
    wp.rcNormalPosition.right  += dx;
    wp.rcNormalPosition.top    += dy;
    wp.rcNormalPosition.bottom += dy;

    if(pRectLimite) {
        // c'e` un rettangolo-limite, verifichiamolo:
        int dd = wp.rcNormalPosition.left - pRectLimite->left;
        if(dd<0) {
            // la finestra sporge a sinistra
            wp.rcNormalPosition.left -= dd;
            wp.rcNormalPosition.right -= dd;
        } else {
            dd = wp.rcNormalPosition.right - pRectLimite->right;
            if(dd>0) {
                // la finestra sporge a destra
                wp.rcNormalPosition.left -= dd;
                wp.rcNormalPosition.right -= dd;
            }
        }
        dd = wp.rcNormalPosition.top - pRectLimite->top;
        if(dd<0) {
            // la finestra sporge "dall'alto"
            wp.rcNormalPosition.top -= dd;
            wp.rcNormalPosition.bottom -= dd;
        } else {
            // la finestra sporge "dal basso"
            dd = wp.rcNormalPosition.bottom - pRectLimite->bottom;
            if(dd>0) {
                wp.rcNormalPosition.top -= dd;
                wp.rcNormalPosition.bottom -= dd;
            }
        }
    }

    // stabilisce la nuova posizione della finestra
    return SetWindowPlacement(hwnd, &wp);
}
