// aggnot.c
//
// aggiunge a un controllo la capacita` di inviare notifiche, via
// WM_COMMAND, al dialogo che lo contiene, sulla base di
// eventi Windows WM_xxx ricevuti dal controllo -- la codifica
// della corrispondenza evento->notifica e` nell'array pCodici,
// che agli indici pari ha codici WM_xxx, a quelli dispari subito
// dopo il codice di notifica da usare, terminato logicamente da
// uno 0 a indice pari; l'array puo` venire modificato nel corso
// dell'esecuzione, per cambiare il comportamento del controllo
//
#define STRICT
#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#include "aggnot.h"

// la window procedure di superclassing
static LRESULT CALLBACK
WpSuper(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
    // recupera i codici di corrispondenza messaggio->notifica
    long* pCodici = (long*)GetProp(hwnd,"AN_DT");
    if(pCodici) {
        // scandisce l'array sino a una corrispondenza, o
        // sino allo 0 di terminazione
        int i=0;
        while(pCodici[i]) {
            if(pCodici[i] == (long)uMsg) {
                // trovata la corrispondenza!
                SendMessage(GetParent(hwnd), WM_COMMAND,
                    MAKELONG(GetDlgCtrlID(hwnd),pCodici[i+1]), 
                    (LPARAM)hwnd);
                break;
            }
            i += 2;
        }
    }
    // recupera la window procedure che ha subclassato
    WNDPROC wp = (WNDPROC)GetProp(hwnd,"AN_WP");
    if(uMsg == WM_DESTROY) {
        // alla distruzione, deve fare pulizia
        RemoveProp(hwnd, "AN_WP");
        RemoveProp(hwnd, "AN_DT");
    }
    if(wp)
        return CallWindowProc(wp, hwnd, uMsg, wParam, lParam);
    else
        return DefWindowProc(hwnd, uMsg, wParam, lParam); 
}

//
// istalla la procedura di subclassing e le due proprieta` AN_WP
// (precedente window procedure) e AN_DT (puntatore ai codici)
//
void Aggiungi_Notifiche(HWND hwndDialogo, int idControllo, long* pCodici)
{
    HWND hwnd = GetDlgItem(hwndDialogo,idControllo);
    WNDPROC wp = (WNDPROC)SetWindowLong(hwnd,GWL_WNDPROC,(LONG)WpSuper);
    SetProp(hwnd,"AN_WP",(HANDLE)wp);
    SetProp(hwnd,"AN_DT",(HANDLE)pCodici);
}

